/*
 * $QNXLicenseC:
 * Copyright 2010, QNX Software Systems.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"). You
 * may not reproduce, modify or distribute this software except in
 * compliance with the License. You may obtain a copy of the License
 * at: http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTIES OF ANY KIND, either express or implied.
 *
 * This file may contain contributions from others, either as
 * contributors under the License or as licensors under other terms.
 * Please review this entire file for other proprietary rights or license
 * notices, as well as the QNX Development Suite License Guide at
 * http://licensing.qnx.com/license-guide/ for other information.
 * $
 */

/*
 * Synaptics TouchCom touchscreen driver
 *
 * Copyright (C) 2017-2020 Synaptics Incorporated. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * INFORMATION CONTAINED IN THIS DOCUMENT IS PROVIDED "AS-IS," AND SYNAPTICS
 * EXPRESSLY DISCLAIMS ALL EXPRESS AND IMPLIED WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
 * AND ANY WARRANTIES OF NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS.
 * IN NO EVENT SHALL SYNAPTICS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, PUNITIVE, OR CONSEQUENTIAL DAMAGES ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OF THE INFORMATION CONTAINED IN THIS DOCUMENT, HOWEVER CAUSED
 * AND BASED ON ANY THEORY OF LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, AND EVEN IF SYNAPTICS WAS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE. IF A TRIBUNAL OF COMPETENT JURISDICTION DOES
 * NOT PERMIT THE DISCLAIMER OF DIRECT DAMAGES OR ANY OTHER DAMAGES, SYNAPTICS'
 * TOTAL CUMULATIVE LIABILITY TO ANY PARTY SHALL NOT EXCEED ONE HUNDRED U.S.
 * DOLLARS.
 */

/**
 * @file syna_tcm2_mtouch.h
 *
 * The header file is used for the Synaptics TouchComm QNX driver.
 * Platform-specific functions and included headers are implemented in
 * syna_touchcom_platform.h and syna_touchcom_runtime.h.
 */

#ifndef _SYNAPTICS_TCM2_QNX_MTOUCH_H_
#define _SYNAPTICS_TCM2_QNX_MTOUCH_H_

#ifdef  __cplusplus
extern "C" {
#endif

#include <sys/types.h>
#ifndef UNITTEST
#include <sys/iofunc.h>
#include <sys/dispatch.h>
#include <assert.h>
#include <screen/screen.h>
#include <sys/neutrino.h>
#include "lib_display_binder.h"
#include "dcmd_pm.h"
#else
#include <stdbool.h>
#include "ipc_header.h"
#include "screen_header.h"
#endif

#include "syna_tcm2_platform.h"
#include "synaptics_touchcom_core_dev.h"
#include "synaptics_touchcom_func_touch.h"
#include "fidm_touch.h"

#ifdef UNITTEST
#define sched_param ut_sched_param
#define sigevent ut_sigevent
#endif

/* driver version */
#define SYNAPTICS_TCM_QNX_DRIVER_VERSION_MAJOR    (1)
#define SYNAPTICS_TCM_QNX_DRIVER_VERSION_MINOR    (2)
#define SYNAPTICS_TCM_QNX_DRIVER_VERSION_MINORS    (1)

/* Pulse codes for receiving pulses from power manager */
#define SYNAPTICS_PM_PREPARE_PULSE                   (_PULSE_CODE_MINAVAIL+5)
#define SYNAPTICS_PM_SUSPEND_PULSE                   (_PULSE_CODE_MINAVAIL+6)
#define SYNAPTICS_PM_RESUME_PULSE                    (_PULSE_CODE_MINAVAIL+7)

#define PM_DEV_NODE                    "/dev/pm"

/* driver status */
#define STATUS_UNKNOWN      0x0000  // default
#define STATUS_INIT         0x0001  // driver is initialized

/* touched object status */
#define TOUCH_FINGER_DOWN        (1)
#define TOUCH_FINGER_UP            (0)
#define TOUCH_FINGER_NOP        (-1)

/*mtouch driver has a dependency with qvm,init func should be returned before qvm starts*/
/*So max we can have 2 retry attempts in cold boot*/
#define MAX_HW_RETRY_COUNT  2

struct syna_msg_thread {
    pthread_t fidm_thread;
    name_attach_t *fidm_attach;
    int fidm_coid;
    char *fidm_attach_point;
};

/**
 * @brief: context of the synaptics QNX mtouch driver
 *
 * The structure defines the kernel specific data in mtouch device driver
 */
struct syna_tcm_dev {

    /* TouchComm device core context */
    struct tcm_dev *tcm_dev;

    /* Generic touched data generated by tcm core lib */
    struct tcm_touch_data_blob *tp_data;

    syna_pal_mutex_t tp_event_mutex;

    unsigned char prev_obj_status[MAX_NUM_OBJECTS];

    /* Buffer stored the irq event data */
    struct tcm_buffer event_data;

    /* Hardware interface layer */
    struct syna_hw_interface *hw_if;

    /* handler to connect to the Input Events library */
    struct mtouch_device *inputevents_hdlr;

    struct syna_msg_thread *msg_thread;

    /* thread for ISR implementation */
    pthread_t isr_thread;

    /* device driver status */
    int status;
    bool is_connected;
  
    /*Touch resolution */
    unsigned int width;
    unsigned int height;
    unsigned int max_touchpoints;
  
    unsigned verbose;

    /* pm */
    char* pm_dev;
    int pm_fd;
    enum pm_state syn_pm_state;

    /* screen */
    screen_context_t screen_ctx;
    screen_window_t window;

    /* window */
    unsigned int win_height;
    unsigned int win_width;
    unsigned int win_xpos;
    unsigned int win_ypos;
    unsigned int disp_id;
    char* win_name;

    char* dev_status_path;

    uint8_t touch_rtd[MAX_RTD_DATA_LENGTH];
    uint8_t touch_rtd_len;
    bool touch_rtd_readflag;

    uint8_t knob_rtd[MAX_KNOB_RTD_DATA_LENGTH];
    uint8_t knob_rtd_len;
    bool knob_rtd_readflag;

    int display_group_id;

    /* QNX related stuff
     * thread_chid: channel ID
     * thread_coid: connection ID
     * thread_attr: the thread attributes
     * thread_param: the scheduling parameters
     * thread_event: an event
     */
    int thread_chid;
    int thread_coid;
    pthread_attr_t thread_attr;
    struct sched_param thread_param;
    struct sigevent thread_event;

    /* firmware upgrade related stuff
     * startup_fw_update: flag to perform fw update during the startup
     * fw_image: the path of target fw image file
     */
    unsigned int startup_fw_update;
    char *fw_image_path;

    int     faceplate_coid;
    unsigned sync_point;
};

int mtouch_create_qvm_window(struct syna_tcm_dev *p_dev);
int syna_mtouch_tp_intr_attach(struct syna_tcm_dev *p_dev);
int syna_mtouch_suspend(struct syna_tcm_dev *dev);
int syna_mtouch_resume(struct syna_tcm_dev *dev);
int syna_tcm_send_knob_data(struct syna_tcm_dev *p_dev);
int syna_tcm_get_display_grpid(struct syna_tcm_dev *p_dev);
void syna_release_touch(struct syna_tcm_dev *p_dev);
#ifdef  __cplusplus
}
#endif

#endif /* end of _SYNAPTICS_TCM2_QNX_MTOUCH_H_ */
